const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const OrderSchema = new Schema({
    userId: {
        type: String,
    },
    items: [{
        productId: {
            type: String,
        },
        name: String,
        quantity: {
            type: Number,
            required: true,
            min: [1, 'Quantity can not be less then 1.']
        },
        image: {
            data: Buffer, // Store the filename as a string
            contentType: String,
          },
        price: Number
    }],
    bill: {
        type: Number,
        required: true
    },
    date_added: {
        type: Date,
        default: Date.now
    },
    address:{
        type:String,
    },
    payment_method:{
        type:String,
    },
    status:{
        type: String,
        enum: ['Cancelled', 'Delivered','Processing'],

    },
    paymentIntentId:{
        type:String,
    }
})

module.exports = Order = mongoose.model('order',OrderSchema);